/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.poweroftwochoices;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoServiceInstanceFoundException;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.ServiceInstanceWithStatGathering;
import io.smallrye.stork.loadbalancer.requests.InflightRequestCollector;
import io.smallrye.stork.spi.CallStatisticsCollector;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class PowerOfTwoChoicesLoadBalancer
implements LoadBalancer {
    private final InflightRequestCollector collector = new InflightRequestCollector();
    private final Random random;

    protected PowerOfTwoChoicesLoadBalancer(boolean useSecureRandom) {
        this.random = useSecureRandom ? new SecureRandom() : new Random();
    }

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        int concurrencyOfSecond;
        if (serviceInstances.isEmpty()) {
            throw new NoServiceInstanceFoundException("No service instance found");
        }
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>(serviceInstances);
        int count = instances.size();
        if (count == 1) {
            return (ServiceInstance)instances.get(0);
        }
        ServiceInstance first = (ServiceInstance)instances.get(this.random.nextInt(count));
        ServiceInstance second = (ServiceInstance)instances.get(this.random.nextInt(count));
        int concurrencyOfFirst = this.collector.get(first.getId());
        if (concurrencyOfFirst < (concurrencyOfSecond = this.collector.get(second.getId()))) {
            return new ServiceInstanceWithStatGathering(first, (CallStatisticsCollector)this.collector);
        }
        return new ServiceInstanceWithStatGathering(second, (CallStatisticsCollector)this.collector);
    }

    public boolean requiresStrictRecording() {
        return false;
    }
}

