/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.api.config.LoadBalancerConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RandomConfiguration
implements LoadBalancerConfig {
    private final Map<String, String> parameters;

    public RandomConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public RandomConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "random";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private RandomConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new RandomConfiguration(copy);
    }

    public String getUseSecureRandom() {
        String result = this.parameters.get("use-secure-random");
        return result == null ? "false" : result;
    }

    public RandomConfiguration withUseSecureRandom(String value) {
        return this.extend("use-secure-random", value);
    }
}

