package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.loadbalancer.random.RandomConfiguration;
import io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceDiscovery;

/**
 * LoadBalancerLoader for io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider
 */
 public class RandomLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider provider = new io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider();
   @Override
   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.loadbalancer.random.RandomConfiguration typedConfig = new io.smallrye.stork.loadbalancer.random.RandomConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "random";
   }
}
