/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoServiceInstanceFoundException;
import io.smallrye.stork.api.ServiceInstance;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class RandomLoadBalancer
implements LoadBalancer {
    private final Random random;

    protected RandomLoadBalancer(boolean useSecureRandom) {
        this.random = useSecureRandom ? new SecureRandom() : new Random();
    }

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            throw new NoServiceInstanceFoundException("No service instance found");
        }
        int size = serviceInstances.size();
        if (size == 1) {
            return serviceInstances.iterator().next();
        }
        ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>(serviceInstances);
        return (ServiceInstance)list.get(this.random.nextInt(size));
    }

    public boolean requiresStrictRecording() {
        return false;
    }
}

