/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.leastresponsetime;

import io.smallrye.stork.spi.CallStatisticsCollector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class CallStatistics
implements CallStatisticsCollector {
    private final AtomicLong callCount = new AtomicLong(1L);
    private final ConcurrentHashMap<Long, CallsData> storage = new ConcurrentHashMap();
    static double errorImportanceDeclineFactor = 0.999;
    static double[] declineFactorPowers = new double[16];
    static double responseTimeFactor = 0.5;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeResult(long id, long timeInNs, Throwable error) {
        long callIdx = this.callCount.incrementAndGet();
        while (true) {
            CallsData newData;
            CallsData oldData;
            if ((oldData = this.storage.get(id)) != null) {
                if (error == null) {
                    double newTotalTime = oldData.weightedTotalTime * responseTimeFactor + (double)timeInNs;
                    double newWeightSum = oldData.weightSum * responseTimeFactor + 1.0;
                    newData = new CallsData(callIdx, oldData.lastFailure, newTotalTime, newWeightSum, oldData.weightedErrorCount);
                } else {
                    double rescaledFailureRate = oldData.scaledErrorCount(callIdx - oldData.lastFailure);
                    newData = new CallsData(oldData.lastSuccess, callIdx, oldData.weightedTotalTime, oldData.weightSum, rescaledFailureRate + 1.0);
                }
                if (!this.storage.replace(id, oldData, newData)) continue;
                return;
            }
            newData = error == null ? new CallsData(callIdx, 0L, timeInNs, 1.0, 0.0) : new CallsData(0L, callIdx, 0.0, 0.0, 1.0);
            if (this.storage.put(callIdx, newData) == null) return;
        }
    }

    public CallsData statsForInstance(long id) {
        return this.storage.get(id);
    }

    public long currentCall() {
        return this.callCount.get();
    }

    public CallsData init(long id) {
        CallsData result = new CallsData(0L, 0L, 0.0, 0.0, 0.0);
        this.storage.put(id, result);
        return result;
    }

    static {
        CallStatistics.declineFactorPowers[0] = 1.0;
        CallStatistics.declineFactorPowers[1] = errorImportanceDeclineFactor;
        for (int i = 2; i < 16; ++i) {
            CallStatistics.declineFactorPowers[i] = declineFactorPowers[i - 1] * declineFactorPowers[i - 1];
        }
    }

    public static class CallsData {
        final long lastFailure;
        final long lastSuccess;
        final double weightedTotalTime;
        final double weightSum;
        final double weightedErrorCount;
        final AtomicReference<Boolean> forcedAttemptInProgress = new AtomicReference<Boolean>(false);

        private CallsData(long lastSuccess, long lastFailure, double weighedTotalTime, double weightSum, double weighedErrorCount) {
            this.lastFailure = lastFailure;
            this.lastSuccess = lastSuccess;
            this.weightedTotalTime = weighedTotalTime;
            this.weightSum = weightSum;
            this.weightedErrorCount = weighedErrorCount;
        }

        public double scaledErrorCount(long timeSinceLastError) {
            if (this.weightedErrorCount == 0.0) {
                return 0.0;
            }
            double result = this.weightedErrorCount;
            for (int i = 0; i < 16; ++i) {
                int powerOf2 = 1 << i;
                if ((timeSinceLastError & (long)powerOf2) == 0L) continue;
                result *= declineFactorPowers[i];
            }
            return result;
        }

        public double scaledTime() {
            return this.weightedTotalTime / this.weightSum;
        }
    }
}

