/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.leastresponsetime;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoServiceInstanceFoundException;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.ServiceInstanceWithStatGathering;
import io.smallrye.stork.loadbalancer.leastresponsetime.CallStatistics;
import io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeLoadBalancerProviderConfiguration;
import io.smallrye.stork.spi.CallStatisticsCollector;
import java.util.Collection;

public class LeastResponseTimeLoadBalancer
implements LoadBalancer {
    private final CallStatistics callStatistics = new CallStatistics();
    private final long retryAfterFailureTreshold;
    private final long forceRetryThreshold;

    public LeastResponseTimeLoadBalancer(LeastResponseTimeLoadBalancerProviderConfiguration config) {
        this.retryAfterFailureTreshold = Long.parseLong(config.getRetryAfterFailureThreshold());
        this.forceRetryThreshold = Long.parseLong(config.getForceRetryThreshold());
    }

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            throw new NoServiceInstanceFoundException("No service instance found");
        }
        ServiceInstance best = null;
        CallStatistics.CallsData bestData = null;
        for (ServiceInstance instance : serviceInstances) {
            CallStatistics.CallsData callsData = this.callStatistics.statsForInstance(instance.getId());
            if (callsData == null) {
                callsData = this.callStatistics.init(instance.getId());
                callsData.forcedAttemptInProgress.set(true);
                best = instance;
                break;
            }
            if (bestData == null) {
                bestData = callsData;
                best = instance;
                continue;
            }
            if (this.timeToRetry(callsData)) {
                best = instance;
                break;
            }
            if (!this.isBetterThan(callsData, bestData)) continue;
            best = instance;
            bestData = callsData;
        }
        return new ServiceInstanceWithStatGathering(best, (CallStatisticsCollector)this.callStatistics);
    }

    private boolean isBetterThan(CallStatistics.CallsData callsData, CallStatistics.CallsData bestData) {
        if (bestData.lastSuccess != 0L) {
            if (callsData.lastSuccess == 0L) {
                return false;
            }
            long now = this.callStatistics.currentCall();
            return callsData.scaledTime() * (1.0 + callsData.scaledErrorCount(now - callsData.lastFailure)) <= bestData.scaledTime() * (1.0 + bestData.scaledErrorCount(now - bestData.lastFailure));
        }
        if (callsData.lastSuccess != 0L) {
            return true;
        }
        return callsData.lastFailure == 0L || callsData.lastFailure < bestData.lastFailure;
    }

    private boolean timeToRetry(CallStatistics.CallsData callsData) {
        if (callsData == null) {
            return true;
        }
        long now = this.callStatistics.currentCall();
        return now - callsData.lastFailure > this.retryAfterFailureTreshold && now - callsData.lastSuccess > this.forceRetryThreshold && callsData.forcedAttemptInProgress.compareAndSet(false, true);
    }
}

