package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.loadbalancer.random.StickyConfiguration;
import io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.LoadBalancerConfig;
import io.smallrye.stork.api.ServiceDiscovery;

/**
 * LoadBalancerLoader for io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider
 */
 public class StickyLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider provider = new io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider();
   @Override
   public LoadBalancer createLoadBalancer(LoadBalancerConfig config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.loadbalancer.random.StickyConfiguration typedConfig = new io.smallrye.stork.loadbalancer.random.StickyConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "sticky";
   }
}
