/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.api.config.LoadBalancerConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StickyConfiguration
implements LoadBalancerConfig {
    private final Map<String, String> parameters;

    public StickyConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public StickyConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "sticky";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private StickyConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new StickyConfiguration(copy);
    }

    public String getFailureBackoffTime() {
        String result = this.parameters.get("failure-backoff-time");
        return result == null ? "0" : result;
    }

    public StickyConfiguration withFailureBackoffTime(String value) {
        return this.extend("failure-backoff-time", value);
    }
}

