/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.loadbalancer.random.StickyConfiguration;
import io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider;
import io.smallrye.stork.spi.internal.LoadBalancerLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class StickyLoadBalancerProviderLoader
implements LoadBalancerLoader {
    private final StickyLoadBalancerProvider provider;

    public StickyLoadBalancerProviderLoader() {
        StickyLoadBalancerProvider actual = null;
        try {
            actual = (StickyLoadBalancerProvider)CDI.current().select(StickyLoadBalancerProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new StickyLoadBalancerProvider();
        }
        this.provider = actual;
    }

    public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
        StickyConfiguration typedConfig = new StickyConfiguration(config.parameters());
        return this.provider.createLoadBalancer(typedConfig, serviceDiscovery);
    }

    public String type() {
        return "sticky";
    }
}

