/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoAcceptableServiceInstanceFoundException;
import io.smallrye.stork.api.NoServiceInstanceFoundException;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.ServiceInstanceWithStatGathering;
import io.smallrye.stork.spi.CallStatisticsCollector;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class StickyLoadBalancer
implements LoadBalancer,
CallStatisticsCollector {
    private final long failureBackOffNs;
    private final LinkedHashMap<Long, Long> failedInstances = new LinkedHashMap();
    private volatile ServiceInstanceWithStatGathering lastSelected;

    public StickyLoadBalancer(Duration failureBackOff) {
        this.failureBackOffNs = failureBackOff.toNanos();
    }

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            throw new NoServiceInstanceFoundException("No service instance found");
        }
        if (this.lastSelected != null) {
            for (ServiceInstance instance : serviceInstances) {
                if (instance.getId() != this.lastSelected.getId()) continue;
                return this.lastSelected;
            }
        }
        Map<Long, ServiceInstance> instanceMap = serviceInstances.stream().collect(Collectors.toMap(ServiceInstance::getId, i -> i));
        this.lastSelected = this.selectNextInstance(instanceMap);
        return this.lastSelected;
    }

    private ServiceInstanceWithStatGathering selectNextInstance(Map<Long, ServiceInstance> serviceInstances) {
        for (ServiceInstance serviceInstance : serviceInstances.values()) {
            if (this.failedInstances.containsKey(serviceInstance.getId())) continue;
            return new ServiceInstanceWithStatGathering(serviceInstance, (CallStatisticsCollector)this);
        }
        Iterator<Map.Entry<Long, Long>> failedInstanceIterator = this.failedInstances.entrySet().iterator();
        long now = System.nanoTime();
        while (failedInstanceIterator.hasNext()) {
            Map.Entry<Long, Long> oldestFailedInstance = failedInstanceIterator.next();
            Long instanceId = oldestFailedInstance.getKey();
            Long lastFailureTime = oldestFailedInstance.getValue();
            if (now - lastFailureTime < this.failureBackOffNs) break;
            failedInstanceIterator.remove();
            ServiceInstance serviceInstance = serviceInstances.get(instanceId);
            if (serviceInstance == null) continue;
            this.lastSelected = new ServiceInstanceWithStatGathering(serviceInstance, (CallStatisticsCollector)this);
            return this.lastSelected;
        }
        throw new NoAcceptableServiceInstanceFoundException("Each of the available service instances failed within the configured failure-backoff-time");
    }

    public void recordEnd(long serviceInstanceId, Throwable error) {
        this.recordEndAtTime(serviceInstanceId, error, System.nanoTime());
    }

    void recordEndAtTime(long serviceInstanceId, Throwable error, long currentTime) {
        if (error != null) {
            this.failedInstances.put(serviceInstanceId, currentTime);
            this.lastSelected = null;
        }
    }

    @Deprecated
    LinkedHashMap<Long, Long> getFailedInstances() {
        return new LinkedHashMap<Long, Long>(this.failedInstances);
    }
}

