package io.smallrye.stork.loadbalancer.random;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import io.smallrye.stork.api.config.ConfigWithType;

/**
 *  Configuration for the {@code StickyLoadBalancerProvider} LoadBalancer.
 */
 public class StickyConfiguration implements io.smallrye.stork.api.config.ConfigWithType{
   private final Map<String, String> parameters;

   /**
    * Creates a new StickyConfiguration
    *
    * @param params the parameters, must not be {@code null}
    */
   public StickyConfiguration(Map<String, String> params) {
      parameters = Collections.unmodifiableMap(params);
   }

   /**
    * Creates a new StickyConfiguration
    */
   public StickyConfiguration() {
      parameters = Collections.emptyMap();
   }


  /**
   * @return the type
   */
   @Override
   public String type() {
      return "sticky";
   }


   /**
    * @return the parameters
    */
   @Override
   public Map<String, String> parameters() {
      return parameters;
   }

   private StickyConfiguration extend(String key, String value) {
      Map<String, String> copy = new HashMap<>(parameters);
      copy.put(key, value);
      return new StickyConfiguration(copy);
   }

   /**
    * After how much time, a service instance that has failed can be reused. By default: 0
    *
    * @return the configured failure-backoff-time, {@code 0} if not set
    */
   public String getFailureBackoffTime() {
      String result = parameters.get("failure-backoff-time");
      return result == null ? "0" : result;
   }

   /**
    * Set the 'failure-backoff-time' attribute. Default is 0.
    * 
    * @param value the value for failure-backoff-time
    * @return the current StickyConfiguration to chain calls
    */
   public StickyConfiguration withFailureBackoffTime(String value) {
      return extend("failure-backoff-time", value);
   }
}
