package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.loadbalancer.random.StickyConfiguration;
import io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * LoadBalancerLoader for io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider
 */
 @ApplicationScoped
 public class StickyLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider provider;
   public StickyLoadBalancerProviderLoader() {
       io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.loadbalancer.random.StickyLoadBalancerProvider();
       } 
       this.provider = actual;
   }

   @Override
   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.loadbalancer.random.StickyConfiguration typedConfig = new io.smallrye.stork.loadbalancer.random.StickyConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "sticky";
   }
}
