/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.LoadBalancerAttribute;
import io.smallrye.stork.api.config.LoadBalancerType;
import io.smallrye.stork.loadbalancer.random.StickyConfiguration;
import io.smallrye.stork.loadbalancer.random.StickyLoadBalancer;
import io.smallrye.stork.spi.LoadBalancerProvider;
import io.smallrye.stork.utils.DurationUtils;
import jakarta.enterprise.context.ApplicationScoped;

@LoadBalancerType(value="sticky")
@LoadBalancerAttribute(name="failure-backoff-time", defaultValue="0", description="After how much time, a service instance that has failed can be reused.")
@ApplicationScoped
public class StickyLoadBalancerProvider
implements LoadBalancerProvider<StickyConfiguration> {
    static final String TYPE = "sticky";
    static final String FAILURE_BACKOFF_TIME = "failure-backoff-time";

    public LoadBalancer createLoadBalancer(StickyConfiguration config, ServiceDiscovery serviceDiscovery) {
        return new StickyLoadBalancer(DurationUtils.parseDuration((String)config.getFailureBackoffTime(), (String)FAILURE_BACKOFF_TIME));
    }
}

