/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.microprofile;

import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.config.ConfigProvider;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class MicroProfileConfigProvider
implements ConfigProvider {
    private static final Logger log = Logger.getLogger(MicroProfileConfigProvider.class);
    private static final String CONFIG_PROPERTY_PART_EXPRESSION = "\".*\"|[^.]+";
    private static final Pattern CONFIG_PROP_PART = Pattern.compile("\".*\"|[^.]+");
    public static final String LOAD_BALANCER = "load-balancer";
    public static final String LOAD_BALANCER_EMBEDDED = "load-balancer.type";
    public static final String SERVICE_DISCOVERY = "service-discovery";
    public static final String SERVICE_DISCOVERY_EMBEDDED = "service-discovery.type";
    public static final String SERVICE_REGISTRAR = "service-registrar";
    public static final String SERVICE_REGISTRAR_EMBEDDED = "service-registrar.type";
    private final List<ServiceConfig> serviceConfigs = new ArrayList<ServiceConfig>();

    public MicroProfileConfigProvider() {
        Config config = org.eclipse.microprofile.config.ConfigProvider.getConfig();
        HashMap<String, Map> propertiesByServiceName = new HashMap<String, Map>();
        HashMap propertiesByRegistrarName = new HashMap();
        for (String string : config.getPropertyNames()) {
            Matcher matcher = CONFIG_PROP_PART.matcher(string);
            if (!matcher.find() || !"stork".equals(matcher.group())) continue;
            if (!matcher.find()) {
                log.warn((Object)("Potentially invalid property for SmallRye Stork: " + string));
            }
            String serviceName = this.unwrapFromQuotes(matcher.group());
            int serviceNameEndIdx = matcher.end();
            if (!matcher.find()) {
                log.warn((Object)("Potentially invalid property for SmallRye Stork: " + string));
            }
            Map serviceProperties = propertiesByServiceName.computeIfAbsent(serviceName, ignored -> new HashMap());
            String serviceProperty = this.propertyKey(string.substring(serviceNameEndIdx));
            serviceProperties.put(serviceProperty, (String)config.getValue(string, String.class));
        }
        for (Map.Entry entry : propertiesByServiceName.entrySet()) {
            SimpleServiceConfig serviceConfig = this.buildServiceConfig(entry);
            this.serviceConfigs.add((ServiceConfig)serviceConfig);
        }
    }

    private SimpleServiceConfig buildServiceConfig(Map.Entry<String, Map<String, String>> serviceEntry) {
        String serviceRegistrarType;
        String serviceDiscoveryType;
        SimpleServiceConfig.Builder builder = new SimpleServiceConfig.Builder();
        Map<String, String> properties = serviceEntry.getValue();
        String serviceName = serviceEntry.getKey();
        String loadBalancerType = properties.get(LOAD_BALANCER);
        if (loadBalancerType == null) {
            loadBalancerType = properties.get(LOAD_BALANCER_EMBEDDED);
        }
        builder.setServiceName(serviceName);
        if (loadBalancerType != null) {
            SimpleServiceConfig.SimpleLoadBalancerConfig loadBalancerConfig = new SimpleServiceConfig.SimpleLoadBalancerConfig(loadBalancerType, this.propertiesForPrefix(LOAD_BALANCER, properties));
            builder = builder.setLoadBalancer((ConfigWithType)loadBalancerConfig);
        }
        if ((serviceDiscoveryType = properties.get(SERVICE_DISCOVERY)) == null) {
            serviceDiscoveryType = properties.get(SERVICE_DISCOVERY_EMBEDDED);
        }
        if (serviceDiscoveryType != null) {
            SimpleServiceConfig.SimpleServiceDiscoveryConfig serviceDiscoveryConfig = new SimpleServiceConfig.SimpleServiceDiscoveryConfig(serviceDiscoveryType, this.propertiesForPrefix(SERVICE_DISCOVERY, properties));
            builder = builder.setServiceDiscovery((ConfigWithType)serviceDiscoveryConfig);
        }
        if ((serviceRegistrarType = properties.get(SERVICE_REGISTRAR)) == null) {
            serviceRegistrarType = properties.get(SERVICE_REGISTRAR_EMBEDDED);
        }
        if (serviceRegistrarType != null) {
            SimpleServiceConfig.SimpleServiceRegistrarConfig serviceRegistrarConfig = new SimpleServiceConfig.SimpleServiceRegistrarConfig(serviceRegistrarType, this.propertiesForPrefix(SERVICE_REGISTRAR, properties));
            builder = builder.setServiceRegistrar((ConfigWithType)serviceRegistrarConfig);
        }
        return builder.build();
    }

    private String unwrapFromQuotes(String text) {
        if (text.length() < 2) {
            return text;
        }
        if (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private String propertyKey(String text) {
        if (!text.isEmpty() && text.charAt(0) == '.') {
            return text.substring(1);
        }
        return text;
    }

    private Map<String, String> propertiesForPrefix(String prefix, Map<String, String> original) {
        prefix = ((String)prefix).endsWith(".") ? prefix : (String)prefix + ".";
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : original.entrySet()) {
            String propertyName = entry.getKey();
            if (!propertyName.startsWith((String)prefix)) continue;
            String nameWithoutPrefix = propertyName.substring(((String)prefix).length());
            result.put(nameWithoutPrefix, entry.getValue());
        }
        return result;
    }

    public List<ServiceConfig> getConfigs() {
        return this.serviceConfigs;
    }

    public int priority() {
        return 100;
    }
}

