/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.microprofile;

import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.config.ConfigProvider;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import io.smallrye.stork.utils.StorkConfigUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroProfileConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(MicroProfileConfigProvider.class);
    private final List<ServiceConfig> serviceConfigs = new ArrayList<ServiceConfig>();

    public MicroProfileConfigProvider() {
        Config config = org.eclipse.microprofile.config.ConfigProvider.getConfig();
        HashMap propertiesByServiceName = new HashMap();
        for (String string : config.getPropertyNames()) {
            StorkConfigUtils.computeServiceProperty(propertiesByServiceName, (String)string, (String)((String)config.getValue(string, String.class)));
        }
        for (Map.Entry entry : propertiesByServiceName.entrySet()) {
            SimpleServiceConfig serviceConfig = StorkConfigUtils.buildServiceConfig((Map.Entry)entry);
            this.serviceConfigs.add((ServiceConfig)serviceConfig);
        }
    }

    public List<ServiceConfig> getConfigs() {
        return this.serviceConfigs;
    }

    public int priority() {
        return 100;
    }
}

