package io.smallrye.stork.servicediscovery.composite;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import io.smallrye.stork.api.config.ConfigWithType;

/**
 *  Configuration for the {@code CompositeServiceDiscoveryProvider} ServiceDiscovery.
 */
 public class CompositeConfiguration implements io.smallrye.stork.api.config.ConfigWithType{
   private final Map<String, String> parameters;

   /**
    * Creates a new CompositeConfiguration
    *
    * @param params the parameters, must not be {@code null}
    */
   public CompositeConfiguration(Map<String, String> params) {
      parameters = Collections.unmodifiableMap(params);
   }

   /**
    * Creates a new CompositeConfiguration
    */
   public CompositeConfiguration() {
      parameters = Collections.emptyMap();
   }


  /**
   * @return the type
   */
   @Override
   public String type() {
      return "composite";
   }


   /**
    * @return the parameters
    */
   @Override
   public Map<String, String> parameters() {
      return parameters;
   }

   private CompositeConfiguration extend(String key, String value) {
      Map<String, String> copy = new HashMap<>(parameters);
      copy.put(key, value);
      return new CompositeConfiguration(copy);
   }

   /**
    * A comma-separated list of services that this services consists of.
    *
    * @return the configured services, @{code null} if not set
    */
   public String getServices() {
      return parameters.get("services");
   }

   /**
    * Set the 'services' attribute.
    * 
    * @param value the value for services
    * @return the current CompositeConfiguration to chain calls
    */
   public CompositeConfiguration withServices(String value) {
      return extend("services", value);
   }
}
