/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.composite;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CompositeConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public CompositeConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public CompositeConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "composite";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private CompositeConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new CompositeConfiguration(copy);
    }

    public String getServices() {
        return this.parameters.get("services");
    }

    public CompositeConfiguration withServices(String value) {
        return this.extend("services", value);
    }
}

