/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.composite;

import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.servicediscovery.composite.CompositeConfiguration;
import io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscoveryProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class CompositeServiceDiscoveryProviderLoader
implements ServiceDiscoveryLoader {
    private final CompositeServiceDiscoveryProvider provider;

    public CompositeServiceDiscoveryProviderLoader() {
        CompositeServiceDiscoveryProvider actual = null;
        try {
            actual = (CompositeServiceDiscoveryProvider)CDI.current().select(CompositeServiceDiscoveryProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new CompositeServiceDiscoveryProvider();
        }
        this.provider = actual;
    }

    public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName, ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
        CompositeConfiguration typedConfig = new CompositeConfiguration(config.parameters());
        return this.provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
    }

    public String type() {
        return "composite";
    }
}

