package io.smallrye.stork.servicediscovery.composite;

import io.smallrye.stork.servicediscovery.composite.CompositeConfiguration;
import io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscoveryProvider;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.StorkInfrastructure;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * ServiceDiscoveryLoader for {@link io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscoveryProvider}
 */
 @ApplicationScoped
 public class CompositeServiceDiscoveryProviderLoader implements io.smallrye.stork.spi.internal.ServiceDiscoveryLoader {
   private final io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscoveryProvider provider;
   public CompositeServiceDiscoveryProviderLoader() {
       io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscoveryProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscoveryProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscoveryProvider();
       } 
       this.provider = actual;
   }

   @Override
   public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName,
              ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
      io.smallrye.stork.servicediscovery.composite.CompositeConfiguration typedConfig = new io.smallrye.stork.servicediscovery.composite.CompositeConfiguration(config.parameters());
      return provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "composite";
   }
}
