/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.composite;

import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.api.config.ServiceDiscoveryAttribute;
import io.smallrye.stork.api.config.ServiceDiscoveryType;
import io.smallrye.stork.servicediscovery.composite.CompositeConfiguration;
import io.smallrye.stork.servicediscovery.composite.CompositeServiceDiscovery;
import io.smallrye.stork.spi.ServiceDiscoveryProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;

@ServiceDiscoveryType(value="composite")
@ServiceDiscoveryAttribute(name="services", description="A comma-separated list of services that this services consists of.", required=true)
@ApplicationScoped
public class CompositeServiceDiscoveryProvider
implements ServiceDiscoveryProvider<CompositeConfiguration> {
    public ServiceDiscovery createServiceDiscovery(CompositeConfiguration config, String serviceName, ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
        String serviceList = config.getServices();
        if (serviceList == null) {
            throw new IllegalArgumentException("'services' property missing for service '" + serviceName + "'. Please provide a comma separated list of service names.");
        }
        String[] services = serviceList.split(",");
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (String service : services) {
            if ((service = service.trim()).isBlank()) {
                throw new IllegalArgumentException("Blank constituent service name for service '" + serviceName + "'");
            }
            serviceNames.add(service);
        }
        return new CompositeServiceDiscovery(serviceName, serviceNames);
    }
}

