/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.composite.util;

import java.util.Iterator;
import java.util.List;

class CombiningIterator<T>
implements Iterator<T> {
    private Iterator<T> nextNonEmptyIterator;
    private final Iterator<List<T>> listOfListsIterator;

    CombiningIterator(List<List<T>> contents) {
        this.listOfListsIterator = contents.iterator();
        this.nextNonEmptyIterator = this.nextNonEmptyIterator(this.listOfListsIterator);
    }

    private Iterator<T> nextNonEmptyIterator(Iterator<List<T>> listIterator) {
        while (listIterator.hasNext()) {
            List<T> currentList = listIterator.next();
            if (currentList.isEmpty()) continue;
            return currentList.iterator();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.nextNonEmptyIterator != null && this.nextNonEmptyIterator.hasNext();
    }

    @Override
    public T next() {
        T result = this.nextNonEmptyIterator.next();
        if (!this.nextNonEmptyIterator.hasNext()) {
            this.nextNonEmptyIterator = this.nextNonEmptyIterator(this.listOfListsIterator);
        }
        return result;
    }
}

