/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.composite;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniJoin;
import io.smallrye.stork.api.NoSuchServiceDefinitionException;
import io.smallrye.stork.api.Service;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.StorkServiceRegistry;
import io.smallrye.stork.servicediscovery.composite.util.CombiningList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompositeServiceDiscovery
implements ServiceDiscovery {
    private final Collection<String> serviceNames;
    private final List<ServiceDiscovery> elements = new ArrayList<ServiceDiscovery>();
    private final String serviceName;
    private StorkServiceRegistry stork;
    private volatile boolean initialized;

    public CompositeServiceDiscovery(String serviceName, Collection<String> serviceNames) {
        this.serviceNames = Collections.unmodifiableCollection(serviceNames);
        this.serviceName = serviceName;
    }

    public Uni<List<ServiceInstance>> getServiceInstances() {
        if (!this.initialized) {
            this.init();
        }
        UniJoin.Builder builder = Uni.join().builder();
        for (ServiceDiscovery element : this.elements) {
            builder = builder.add(element.getServiceInstances());
        }
        return builder.joinAll().andFailFast().onItem().transform(CombiningList::new);
    }

    private void init() {
        ArrayList<ServiceDiscovery> list = new ArrayList<ServiceDiscovery>();
        for (String service : this.serviceNames) {
            Service serviceElement = (Service)this.stork.getServiceOptional(service).orElseThrow(() -> new NoSuchServiceDefinitionException(service + " (used in composite service discovery " + this.serviceName + ")"));
            list.add(serviceElement.getServiceDiscovery());
        }
        this.elements.addAll(list);
        this.initialized = true;
    }

    public void initialize(StorkServiceRegistry stork) {
        this.stork = stork;
    }
}

