/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.consul;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConsulRegistrarConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public ConsulRegistrarConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public ConsulRegistrarConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "consul";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private ConsulRegistrarConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new ConsulRegistrarConfiguration(copy);
    }

    public String getConsulHost() {
        String result = this.parameters.get("consul-host");
        return result == null ? "localhost" : result;
    }

    public ConsulRegistrarConfiguration withConsulHost(String value) {
        return this.extend("consul-host", value);
    }

    public String getConsulPort() {
        String result = this.parameters.get("consul-port");
        return result == null ? "8500" : result;
    }

    public ConsulRegistrarConfiguration withConsulPort(String value) {
        return this.extend("consul-port", value);
    }
}

