/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.consul;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConsulConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public ConsulConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public ConsulConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "consul";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private ConsulConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new ConsulConfiguration(copy);
    }

    public String getConsulHost() {
        String result = this.parameters.get("consul-host");
        return result == null ? "localhost" : result;
    }

    public ConsulConfiguration withConsulHost(String value) {
        return this.extend("consul-host", value);
    }

    public String getConsulPort() {
        String result = this.parameters.get("consul-port");
        return result == null ? "8500" : result;
    }

    public ConsulConfiguration withConsulPort(String value) {
        return this.extend("consul-port", value);
    }

    public String getUseHealthChecks() {
        String result = this.parameters.get("use-health-checks");
        return result == null ? "true" : result;
    }

    public ConsulConfiguration withUseHealthChecks(String value) {
        return this.extend("use-health-checks", value);
    }

    public String getApplication() {
        return this.parameters.get("application");
    }

    public ConsulConfiguration withApplication(String value) {
        return this.extend("application", value);
    }

    public String getRefreshPeriod() {
        String result = this.parameters.get("refresh-period");
        return result == null ? "5M" : result;
    }

    public ConsulConfiguration withRefreshPeriod(String value) {
        return this.extend("refresh-period", value);
    }

    public String getSecure() {
        return this.parameters.get("secure");
    }

    public ConsulConfiguration withSecure(String value) {
        return this.extend("secure", value);
    }
}

