/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.consul;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.Metadata;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.CachingServiceDiscovery;
import io.smallrye.stork.impl.DefaultServiceInstance;
import io.smallrye.stork.servicediscovery.consul.ConsulConfiguration;
import io.smallrye.stork.servicediscovery.consul.ConsulMetadataKey;
import io.smallrye.stork.utils.ServiceInstanceIds;
import io.smallrye.stork.utils.ServiceInstanceUtils;
import io.vertx.core.Vertx;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntry;
import io.vertx.ext.consul.ServiceEntryList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConsulServiceDiscovery
extends CachingServiceDiscovery {
    private final ConsulClient client;
    private final String serviceName;
    private final String application;
    private final boolean secure;
    private final boolean passing;

    ConsulServiceDiscovery(String serviceName, ConsulConfiguration config, Vertx vertx) {
        super(config.getRefreshPeriod());
        this.serviceName = serviceName;
        this.secure = this.isSecure(config);
        ConsulClientOptions options = new ConsulClientOptions();
        options.setHost(config.getConsulHost());
        options.setPort(ConsulServiceDiscovery.getPort(serviceName, config.getConsulPort()).intValue());
        this.passing = Boolean.parseBoolean(config.getUseHealthChecks());
        this.application = config.getApplication() == null ? serviceName : config.getApplication();
        this.client = ConsulClient.create((Vertx)vertx, (ConsulClientOptions)options);
    }

    public Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> previousInstances) {
        Uni serviceEntryList = Uni.createFrom().emitter(emitter -> this.client.healthServiceNodes(this.application, this.passing).onComplete(result -> {
            if (result.failed()) {
                emitter.fail(result.cause());
            } else {
                emitter.complete(result.result());
            }
        }));
        return serviceEntryList.onItem().transform(newInstances -> this.toStorkServiceInstances((ServiceEntryList)newInstances, previousInstances));
    }

    private List<ServiceInstance> toStorkServiceInstances(ServiceEntryList serviceEntryList, List<ServiceInstance> previousInstances) {
        List list = serviceEntryList.getList();
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        for (ServiceEntry serviceEntry : list) {
            ServiceInstance matching;
            Service service = serviceEntry.getService();
            Map labels = service.getTags().stream().collect(Collectors.toMap(Function.identity(), s -> s));
            Metadata<ConsulMetadataKey> consulMetadata = this.createConsulMetadata(serviceEntry);
            String address = service.getAddress();
            int port = serviceEntry.getService().getPort();
            if (address == null || address.isEmpty() || address.isBlank()) {
                address = serviceEntry.getNode().getAddress();
            }
            if ((matching = ServiceInstanceUtils.findMatching(previousInstances, (String)address, (int)port)) != null) {
                serviceInstances.add(matching);
                continue;
            }
            DefaultServiceInstance serviceInstance = new DefaultServiceInstance(ServiceInstanceIds.next().longValue(), address, port, this.secure, labels, consulMetadata);
            serviceInstances.add((ServiceInstance)serviceInstance);
        }
        return serviceInstances;
    }

    private Metadata<ConsulMetadataKey> createConsulMetadata(ServiceEntry service) {
        Metadata consulMetadata = Metadata.of(ConsulMetadataKey.class);
        if (service.getService() != null && service.getService().getId() != null) {
            consulMetadata = consulMetadata.with((Enum)ConsulMetadataKey.META_CONSUL_SERVICE_ID, (Object)service.getService().getId());
        }
        if (service.getNode() != null && service.getNode().getName() != null) {
            consulMetadata = consulMetadata.with((Enum)ConsulMetadataKey.META_CONSUL_SERVICE_NODE, (Object)service.getNode().getName());
        }
        if (service.getNode() != null && service.getNode().getAddress() != null) {
            consulMetadata = consulMetadata.with((Enum)ConsulMetadataKey.META_CONSUL_SERVICE_NODE_ADDRESS, (Object)service.getNode().getAddress());
        }
        return consulMetadata;
    }

    protected static Integer getPort(String name, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to parse the property `consul-port` to an integer from the service discovery configuration for service '" + name + "'", e);
        }
    }

    private boolean isSecure(ConsulConfiguration config) {
        return config.getSecure() != null && Boolean.parseBoolean(config.getSecure());
    }
}

