/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.consul;

import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.config.ServiceRegistrarAttribute;
import io.smallrye.stork.api.config.ServiceRegistrarAttributes;
import io.smallrye.stork.api.config.ServiceRegistrarType;
import io.smallrye.stork.servicediscovery.consul.ConsulMetadataKey;
import io.smallrye.stork.servicediscovery.consul.ConsulRegistrarConfiguration;
import io.smallrye.stork.servicediscovery.consul.ConsulServiceRegistrar;
import io.smallrye.stork.spi.ServiceRegistrarProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceRegistrarType(value="consul", metadataKey=ConsulMetadataKey.class)
@ServiceRegistrarAttributes(value={@ServiceRegistrarAttribute(name="consul-host", description="The Consul host.", defaultValue="localhost"), @ServiceRegistrarAttribute(name="consul-port", description="The Consul port.", defaultValue="8500")})
public class ConsulServiceRegistrarProvider
implements ServiceRegistrarProvider<ConsulRegistrarConfiguration, ConsulMetadataKey> {
    private static final Logger log = LoggerFactory.getLogger(ConsulServiceRegistrarProvider.class);

    public ServiceRegistrar<ConsulMetadataKey> createServiceRegistrar(ConsulRegistrarConfiguration config, String serviceRegistrarName, StorkInfrastructure infrastructure) {
        return new ConsulServiceRegistrar(config, serviceRegistrarName, infrastructure);
    }
}

