package io.smallrye.stork.servicediscovery.consul;

import io.smallrye.stork.servicediscovery.consul.ConsulConfiguration;
import io.smallrye.stork.servicediscovery.consul.ConsulServiceDiscoveryProvider;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.StorkInfrastructure;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * ServiceDiscoveryLoader for {@link io.smallrye.stork.servicediscovery.consul.ConsulServiceDiscoveryProvider}
 */
 @ApplicationScoped
 public class ConsulServiceDiscoveryProviderLoader implements io.smallrye.stork.spi.internal.ServiceDiscoveryLoader {
   private final io.smallrye.stork.servicediscovery.consul.ConsulServiceDiscoveryProvider provider;
   public ConsulServiceDiscoveryProviderLoader() {
       io.smallrye.stork.servicediscovery.consul.ConsulServiceDiscoveryProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.servicediscovery.consul.ConsulServiceDiscoveryProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.servicediscovery.consul.ConsulServiceDiscoveryProvider();
       } 
       this.provider = actual;
   }

   @Override
   public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName,
              ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
      io.smallrye.stork.servicediscovery.consul.ConsulConfiguration typedConfig = new io.smallrye.stork.servicediscovery.consul.ConsulConfiguration(config.parameters());
      return provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "consul";
   }
}
