package io.smallrye.stork.servicediscovery.dns;

import io.smallrye.stork.servicediscovery.dns.DnsConfiguration;
import io.smallrye.stork.servicediscovery.dns.DnsServiceDiscoveryProvider;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.StorkInfrastructure;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * ServiceDiscoveryLoader for {@link io.smallrye.stork.servicediscovery.dns.DnsServiceDiscoveryProvider}
 */
 @ApplicationScoped
 public class DnsServiceDiscoveryProviderLoader implements io.smallrye.stork.spi.internal.ServiceDiscoveryLoader {
   private final io.smallrye.stork.servicediscovery.dns.DnsServiceDiscoveryProvider provider;
   public DnsServiceDiscoveryProviderLoader() {
       io.smallrye.stork.servicediscovery.dns.DnsServiceDiscoveryProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.servicediscovery.dns.DnsServiceDiscoveryProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.servicediscovery.dns.DnsServiceDiscoveryProvider();
       } 
       this.provider = actual;
   }

   @Override
   public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName,
              ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
      io.smallrye.stork.servicediscovery.dns.DnsConfiguration typedConfig = new io.smallrye.stork.servicediscovery.dns.DnsConfiguration(config.parameters());
      return provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "dns";
   }
}
