/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.eureka;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EurekaConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public EurekaConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public EurekaConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "eureka";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private EurekaConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new EurekaConfiguration(copy);
    }

    public String getEurekaHost() {
        return this.parameters.get("eureka-host");
    }

    public EurekaConfiguration withEurekaHost(String value) {
        return this.extend("eureka-host", value);
    }

    public String getEurekaPort() {
        String result = this.parameters.get("eureka-port");
        return result == null ? "8761" : result;
    }

    public EurekaConfiguration withEurekaPort(String value) {
        return this.extend("eureka-port", value);
    }

    public String getEurekaContextPath() {
        String result = this.parameters.get("eureka-context-path");
        return result == null ? "/" : result;
    }

    public EurekaConfiguration withEurekaContextPath(String value) {
        return this.extend("eureka-context-path", value);
    }

    public String getApplication() {
        return this.parameters.get("application");
    }

    public EurekaConfiguration withApplication(String value) {
        return this.extend("application", value);
    }

    public String getEurekaTrustAll() {
        String result = this.parameters.get("eureka-trust-all");
        return result == null ? "false" : result;
    }

    public EurekaConfiguration withEurekaTrustAll(String value) {
        return this.extend("eureka-trust-all", value);
    }

    public String getEurekaTls() {
        String result = this.parameters.get("eureka-tls");
        return result == null ? "false" : result;
    }

    public EurekaConfiguration withEurekaTls(String value) {
        return this.extend("eureka-tls", value);
    }

    public String getInstance() {
        return this.parameters.get("instance");
    }

    public EurekaConfiguration withInstance(String value) {
        return this.extend("instance", value);
    }

    public String getRefreshPeriod() {
        String result = this.parameters.get("refresh-period");
        return result == null ? "5M" : result;
    }

    public EurekaConfiguration withRefreshPeriod(String value) {
        return this.extend("refresh-period", value);
    }

    public String getSecure() {
        String result = this.parameters.get("secure");
        return result == null ? "false" : result;
    }

    public EurekaConfiguration withSecure(String value) {
        return this.extend("secure", value);
    }
}

