/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.eureka;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EurekaRegistrarConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public EurekaRegistrarConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public EurekaRegistrarConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "eureka";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private EurekaRegistrarConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new EurekaRegistrarConfiguration(copy);
    }

    public String getEurekaHost() {
        String result = this.parameters.get("eureka-host");
        return result == null ? "localhost" : result;
    }

    public EurekaRegistrarConfiguration withEurekaHost(String value) {
        return this.extend("eureka-host", value);
    }

    public String getEurekaPort() {
        String result = this.parameters.get("eureka-port");
        return result == null ? "8761" : result;
    }

    public EurekaRegistrarConfiguration withEurekaPort(String value) {
        return this.extend("eureka-port", value);
    }

    public String getEurekaContextPath() {
        String result = this.parameters.get("eureka-context-path");
        return result == null ? "/" : result;
    }

    public EurekaRegistrarConfiguration withEurekaContextPath(String value) {
        return this.extend("eureka-context-path", value);
    }

    public String getEurekaTrustAll() {
        String result = this.parameters.get("eureka-trust-all");
        return result == null ? "false" : result;
    }

    public EurekaRegistrarConfiguration withEurekaTrustAll(String value) {
        return this.extend("eureka-trust-all", value);
    }

    public String getEurekaTls() {
        String result = this.parameters.get("eureka-tls");
        return result == null ? "false" : result;
    }

    public EurekaRegistrarConfiguration withEurekaTls(String value) {
        return this.extend("eureka-tls", value);
    }
}

