/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.eureka;

import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.servicediscovery.eureka.EurekaConfiguration;
import io.smallrye.stork.servicediscovery.eureka.EurekaServiceDiscoveryProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class EurekaServiceDiscoveryProviderLoader
implements ServiceDiscoveryLoader {
    private final EurekaServiceDiscoveryProvider provider;

    public EurekaServiceDiscoveryProviderLoader() {
        EurekaServiceDiscoveryProvider actual = null;
        try {
            actual = (EurekaServiceDiscoveryProvider)CDI.current().select(EurekaServiceDiscoveryProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new EurekaServiceDiscoveryProvider();
        }
        this.provider = actual;
    }

    public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName, ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
        EurekaConfiguration typedConfig = new EurekaConfiguration(config.parameters());
        return this.provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
    }

    public String type() {
        return "eureka";
    }
}

