/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.eureka;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.Metadata;
import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.servicediscovery.eureka.EurekaMetadataKey;
import io.smallrye.stork.servicediscovery.eureka.EurekaRegistrarConfiguration;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaServiceRegistrar
implements ServiceRegistrar<EurekaMetadataKey> {
    private static final Logger log = LoggerFactory.getLogger(EurekaServiceRegistrar.class);
    private final EurekaRegistrarConfiguration config;
    private final WebClient client;
    private final String path;

    public EurekaServiceRegistrar(EurekaRegistrarConfiguration config, String serviceName, StorkInfrastructure infrastructure) {
        Vertx vertx = (Vertx)infrastructure.get(Vertx.class, Vertx::vertx);
        this.config = config;
        String host = config.getEurekaHost();
        int port = Integer.parseInt(config.getEurekaPort());
        boolean trustAll = Boolean.parseBoolean(config.getEurekaTrustAll());
        boolean eurekaTls = Boolean.parseBoolean(config.getEurekaTls());
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setDefaultHost(host).setDefaultPort(port).setSsl(eurekaTls).setTrustAll(trustAll));
        Object contextPath = config.getEurekaContextPath();
        if (!((String)contextPath).endsWith("/")) {
            contextPath = (String)contextPath + "/";
        }
        this.path = (String)contextPath + "eureka/apps/";
    }

    public Uni<Void> registerServiceInstance(String serviceName, Metadata<EurekaMetadataKey> metadata, String ipAddress, int defaultPort) {
        return this.registerApplicationInstance(this.client, serviceName, metadata.getMetadata().get((Object)EurekaMetadataKey.META_EUREKA_SERVICE_ID).toString(), "192.5.10.236", "acme.com", defaultPort, null, -1, "UP", "");
    }

    private Uni<Void> registerApplicationInstance(WebClient client, String applicationId, String instanceId, String ipAddress, String virtualAddress, int port, String secureVirtualAddress, int securePort, String state, String path) {
        JsonObject instance = new JsonObject();
        JsonObject registration = new JsonObject();
        instance.put("instance", (Object)registration);
        registration.put("hostName", (Object)"localhost").put("instanceId", (Object)instanceId).put("app", (Object)applicationId).put("ipAddr", (Object)ipAddress).put("vipAddress", (Object)virtualAddress).put("port", (Object)new JsonObject().put("$", (Object)port).put("@enabled", (Object)"true"));
        if (secureVirtualAddress != null) {
            registration.put("secureVipAddress", (Object)secureVirtualAddress);
        }
        if (securePort != -1) {
            registration.put("securePort", (Object)new JsonObject().put("$", (Object)securePort).put("@enabled", (Object)"true"));
        }
        registration.put("status", (Object)state.toUpperCase()).put("dataCenterInfo", (Object)new JsonObject().put("@class", (Object)"com.netflix.appinfo.InstanceInfo$DefaultDataCenterInfo").put("name", (Object)"MyOwn")).put("leaseInfo", (Object)new JsonObject().put("renewalIntervalInSecs", (Object)10000).put("durationInSecs", (Object)10000));
        return client.post(path + "/eureka/apps/" + applicationId).putHeader("content-type", "application/json").putHeader("accept", "application/json").sendJson((Object)instance).replaceWithVoid();
    }
}

