/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.eureka;

import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.config.ServiceRegistrarAttribute;
import io.smallrye.stork.api.config.ServiceRegistrarAttributes;
import io.smallrye.stork.api.config.ServiceRegistrarType;
import io.smallrye.stork.servicediscovery.eureka.EurekaMetadataKey;
import io.smallrye.stork.servicediscovery.eureka.EurekaRegistrarConfiguration;
import io.smallrye.stork.servicediscovery.eureka.EurekaServiceRegistrar;
import io.smallrye.stork.spi.ServiceRegistrarProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import jakarta.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceRegistrarType(value="eureka", metadataKey=EurekaMetadataKey.class)
@ServiceRegistrarAttributes(value={@ServiceRegistrarAttribute(name="eureka-host", description="The Eureka host.", defaultValue="localhost"), @ServiceRegistrarAttribute(name="eureka-port", description="The Eureka port.", defaultValue="8761"), @ServiceRegistrarAttribute(name="eureka-context-path", description="The Eureka server root context path.", defaultValue="/"), @ServiceRegistrarAttribute(name="eureka-trust-all", description="Enable/Disable the TLS certificate verification", defaultValue="false"), @ServiceRegistrarAttribute(name="eureka-tls", description="Use TLS to connect to the Eureka server", defaultValue="false")})
@ApplicationScoped
public class EurekaServiceRegistrarProvider
implements ServiceRegistrarProvider<EurekaRegistrarConfiguration, EurekaMetadataKey> {
    private static final Logger log = LoggerFactory.getLogger(EurekaServiceRegistrarProvider.class);

    public ServiceRegistrar<EurekaMetadataKey> createServiceRegistrar(EurekaRegistrarConfiguration config, String serviceRegistrarName, StorkInfrastructure infrastructure) {
        return new EurekaServiceRegistrar(config, serviceRegistrarName, infrastructure);
    }
}

