/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.eureka;

import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.servicediscovery.eureka.EurekaMetadataKey;
import io.smallrye.stork.servicediscovery.eureka.EurekaRegistrarConfiguration;
import io.smallrye.stork.servicediscovery.eureka.EurekaServiceRegistrarProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.internal.ServiceRegistrarLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class EurekaServiceRegistrarProviderLoader
implements ServiceRegistrarLoader<EurekaMetadataKey> {
    private final EurekaServiceRegistrarProvider provider;

    public EurekaServiceRegistrarProviderLoader() {
        EurekaServiceRegistrarProvider actual = null;
        try {
            actual = (EurekaServiceRegistrarProvider)CDI.current().select(EurekaServiceRegistrarProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new EurekaServiceRegistrarProvider();
        }
        this.provider = actual;
    }

    public ServiceRegistrar<EurekaMetadataKey> createServiceRegistrar(ConfigWithType config, String serviceName, StorkInfrastructure storkInfrastructure) {
        EurekaRegistrarConfiguration typedConfig = new EurekaRegistrarConfiguration(config.parameters());
        return this.provider.createServiceRegistrar(typedConfig, serviceName, storkInfrastructure);
    }

    public String type() {
        return "eureka";
    }
}

