/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.eureka;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.CachingServiceDiscovery;
import io.smallrye.stork.impl.DefaultServiceInstance;
import io.smallrye.stork.servicediscovery.eureka.ApplicationInstance;
import io.smallrye.stork.servicediscovery.eureka.EurekaConfiguration;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.utils.ServiceInstanceIds;
import io.smallrye.stork.utils.ServiceInstanceUtils;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EurekaServiceDiscovery
extends CachingServiceDiscovery {
    private final WebClient client;
    private final String path;
    private final boolean secure;
    private final Optional<String> instance;

    public EurekaServiceDiscovery(EurekaConfiguration config, String serviceName, StorkInfrastructure infrastructure) {
        super(config.getRefreshPeriod());
        this.secure = this.isSecure(config);
        Vertx vertx = (Vertx)infrastructure.get(Vertx.class, Vertx::vertx);
        String host = config.getEurekaHost();
        int port = Integer.parseInt(config.getEurekaPort());
        boolean trustAll = Boolean.parseBoolean(config.getEurekaTrustAll());
        boolean eurekaTls = Boolean.parseBoolean(config.getEurekaTls());
        String app = config.getApplication() == null ? serviceName : config.getApplication();
        this.instance = Optional.ofNullable(config.getInstance());
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setDefaultHost(host).setDefaultPort(port).setSsl(eurekaTls).setTrustAll(trustAll));
        Object contextPath = config.getEurekaContextPath();
        if (!((String)contextPath).endsWith("/")) {
            contextPath = (String)contextPath + "/";
        }
        this.path = (String)contextPath + "eureka/apps/" + app;
    }

    public Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> previousInstances) {
        Uni retrieval = this.client.get(this.path).putHeader("Accept", "application/json;charset=UTF-8").send();
        return retrieval.map(this::getEurekaApplicationInstances).map(this::selectAliveInstances).map(this::selectSecureInstancesIfEnabled).map(this::selectChosenInstanceIfEnabled).map(appInstances -> this.toStorkServiceInstances((Stream<ApplicationInstance>)appInstances, previousInstances));
    }

    private Stream<ApplicationInstance> selectSecureInstancesIfEnabled(Stream<ApplicationInstance> stream) {
        if (!this.secure) {
            return stream;
        }
        return stream.filter(i -> i.securePort.enabled);
    }

    private Stream<ApplicationInstance> selectChosenInstanceIfEnabled(Stream<ApplicationInstance> stream) {
        if (this.instance.isEmpty()) {
            return stream;
        }
        return stream.filter(i -> i.instanceId.equalsIgnoreCase(this.instance.get()));
    }

    private List<ServiceInstance> toStorkServiceInstances(Stream<ApplicationInstance> instances, List<ServiceInstance> previousInstances) {
        return instances.map(instance -> {
            int port;
            String virtualAddress;
            if (this.secure && instance.securePort.enabled) {
                virtualAddress = instance.secureVipAddress;
                if (virtualAddress == null) {
                    virtualAddress = instance.vipAddress;
                }
                port = instance.securePort.port;
            } else {
                virtualAddress = instance.vipAddress;
                port = instance.port.port;
            }
            ServiceInstance matching = ServiceInstanceUtils.findMatching((Collection)previousInstances, (String)virtualAddress, (int)port);
            return matching == null ? new DefaultServiceInstance(ServiceInstanceIds.next().longValue(), virtualAddress, port, this.secure) : matching;
        }).collect(Collectors.toList());
    }

    private Stream<ApplicationInstance> getEurekaApplicationInstances(HttpResponse<Buffer> response) {
        if (response.statusCode() == 404) {
            return Stream.empty();
        }
        this.ensure200(response);
        JsonArray array = response.bodyAsJsonObject().getJsonObject("application").getJsonArray("instance");
        return array.stream().map(o -> (ApplicationInstance)((JsonObject)o).mapTo(ApplicationInstance.class));
    }

    private Stream<ApplicationInstance> selectAliveInstances(Stream<ApplicationInstance> instances) {
        return instances.filter(ApplicationInstance::isUp);
    }

    private void ensure200(HttpResponse<Buffer> resp) {
        if (resp.statusCode() != 200) {
            throw new RuntimeException("Unable to retrieve services from Eureka, expected as 200-OK response, but got " + resp.statusCode() + ", body is: " + resp.bodyAsString());
        }
    }

    private boolean isSecure(EurekaConfiguration config) {
        return config.getSecure() != null && Boolean.parseBoolean(config.getSecure());
    }
}

