/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.knative;

import io.fabric8.knative.client.DefaultKnativeClient;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Service;
import io.fabric8.knative.serving.v1.ServiceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.Metadata;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.CachingServiceDiscovery;
import io.smallrye.stork.impl.DefaultServiceInstance;
import io.smallrye.stork.servicediscovery.knative.KnativeConfiguration;
import io.smallrye.stork.servicediscovery.knative.KnativeMetadataKey;
import io.smallrye.stork.utils.ServiceInstanceIds;
import io.smallrye.stork.utils.ServiceInstanceUtils;
import io.vertx.core.Vertx;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeServiceDiscovery
extends CachingServiceDiscovery {
    static final String METADATA_NAME = "metadata.name";
    private final KnativeClient kn;
    private final String application;
    private final boolean allNamespaces;
    private final String namespace;
    private final boolean secure;
    private final Vertx vertx;
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeServiceDiscovery.class);
    private AtomicBoolean invalidated = new AtomicBoolean();

    public KnativeServiceDiscovery(String serviceName, KnativeConfiguration config, Vertx vertx) {
        super(config.getRefreshPeriod());
        Config base = Config.autoConfigure(null);
        String masterUrl = config.getKnativeHost() == null ? base.getMasterUrl() : config.getKnativeHost();
        this.application = config.getApplication() == null ? serviceName : config.getApplication();
        this.namespace = config.getKnativeNamespace() == null ? base.getNamespace() : config.getKnativeNamespace();
        boolean bl = this.allNamespaces = this.namespace != null && this.namespace.equalsIgnoreCase("all");
        if (this.namespace == null) {
            throw new IllegalArgumentException("Namespace is not configured for service '" + serviceName + "'. Please provide a namespace. Use 'all' to discover services in all namespaces");
        }
        Config k8sConfig = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(masterUrl)).withNamespace(this.namespace)).build();
        this.kn = new DefaultKnativeClient(k8sConfig);
        this.vertx = vertx;
        this.secure = KnativeServiceDiscovery.isSecure(config);
        this.kn.services().inform((ResourceEventHandler)new ResourceEventHandler<Service>(){

            public void onAdd(Service obj) {
                LOGGER.info("Service added: {}", (Object)obj.getMetadata().getName());
                KnativeServiceDiscovery.this.invalidate();
            }

            public void onUpdate(Service oldObj, Service newObj) {
                LOGGER.info("Service updated : {}", (Object)newObj.getMetadata().getName());
                KnativeServiceDiscovery.this.invalidate();
            }

            public void onDelete(Service obj, boolean deletedFinalStateUnknown) {
                LOGGER.info("Service deleted: {}", (Object)obj.getMetadata().getName());
                KnativeServiceDiscovery.this.invalidate();
            }
        });
    }

    public Uni<List<ServiceInstance>> cache(Uni<List<ServiceInstance>> uni) {
        return uni.memoize().until(() -> this.invalidated.get());
    }

    public void invalidate() {
        this.invalidated.set(true);
    }

    public Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> previousInstances) {
        Uni knServicesUni = Uni.createFrom().emitter(emitter -> this.vertx.executeBlocking(future -> {
            ArrayList<Service> items = new ArrayList<Service>();
            if (this.allNamespaces) {
                items.addAll(((ServiceList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.kn.services().inAnyNamespace()).withField(METADATA_NAME, this.application)).list()).getItems());
            } else {
                Service e = (Service)((Resource)((NonNamespaceOperation)this.kn.services().inNamespace(this.namespace)).withName(this.application)).get();
                if (e != null) {
                    items.add(e);
                }
            }
            future.complete(items);
        }, result -> {
            if (result.succeeded()) {
                List knServices = (List)result.result();
                emitter.complete((Object)knServices);
            } else {
                LOGGER.error("Unable to retrieve the knative service from the {} service", (Object)this.application, (Object)result.cause());
                emitter.fail(result.cause());
            }
        }));
        return knServicesUni.onItem().transform(knServices -> this.toStorkServiceInstances((List<Service>)knServices, previousInstances)).invoke(() -> this.invalidated.set(false));
    }

    private List<ServiceInstance> toStorkServiceInstances(List<Service> knServices, List<ServiceInstance> previousInstances) {
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        for (Service knService : knServices) {
            ServiceInstance matching = ServiceInstanceUtils.findMatching(previousInstances, (String)knService.getStatus().getUrl(), (int)8080);
            if (matching != null) {
                serviceInstances.add(matching);
                continue;
            }
            HashMap labels = new HashMap(knService.getMetadata().getLabels() != null ? knService.getMetadata().getLabels() : Collections.emptyMap());
            Metadata knativeMetadata = Metadata.of(KnativeMetadataKey.class);
            String host = knService.getStatus().getUrl();
            try {
                URI uri = new URI(knService.getStatus().getUrl());
                if (uri != null && uri.getScheme() != null && (host = uri.getHost()) == null) {
                    throw new IllegalArgumentException("Invalid URL used: '" + uri + "'");
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage() + " for service: " + this.application);
            }
            serviceInstances.add((ServiceInstance)new DefaultServiceInstance(ServiceInstanceIds.next().longValue(), host, -1, Optional.empty(), this.secure, labels, knativeMetadata.with((Enum)KnativeMetadataKey.META_KNATIVE_SERVICE_ID, (Object)knService.getFullResourceName()).with((Enum)KnativeMetadataKey.META_KNATIVE_NAMESPACE, (Object)knService.getMetadata().getNamespace()).with((Enum)KnativeMetadataKey.META_KNATIVE_LATEST_REVISION, (Object)knService.getStatus().getLatestCreatedRevisionName())));
        }
        return serviceInstances;
    }

    private static boolean isSecure(KnativeConfiguration config) {
        return config.getSecure() != null && Boolean.parseBoolean(config.getSecure());
    }
}

