/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.knative;

import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.servicediscovery.knative.KnativeConfiguration;
import io.smallrye.stork.servicediscovery.knative.KnativeServiceDiscoveryProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class KnativeServiceDiscoveryProviderLoader
implements ServiceDiscoveryLoader {
    private final KnativeServiceDiscoveryProvider provider;

    public KnativeServiceDiscoveryProviderLoader() {
        KnativeServiceDiscoveryProvider actual = null;
        try {
            actual = (KnativeServiceDiscoveryProvider)CDI.current().select(KnativeServiceDiscoveryProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new KnativeServiceDiscoveryProvider();
        }
        this.provider = actual;
    }

    public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName, ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
        KnativeConfiguration typedConfig = new KnativeConfiguration(config.parameters());
        return this.provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
    }

    public String type() {
        return "knative";
    }
}

