/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.knative;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KnativeConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public KnativeConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public KnativeConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "knative";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private KnativeConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new KnativeConfiguration(copy);
    }

    public String getKnativeHost() {
        return this.parameters.get("knative-host");
    }

    public KnativeConfiguration withKnativeHost(String value) {
        return this.extend("knative-host", value);
    }

    public String getKnativeNamespace() {
        return this.parameters.get("knative-namespace");
    }

    public KnativeConfiguration withKnativeNamespace(String value) {
        return this.extend("knative-namespace", value);
    }

    public String getApplication() {
        return this.parameters.get("application");
    }

    public KnativeConfiguration withApplication(String value) {
        return this.extend("application", value);
    }

    public String getRefreshPeriod() {
        String result = this.parameters.get("refresh-period");
        return result == null ? "5M" : result;
    }

    public KnativeConfiguration withRefreshPeriod(String value) {
        return this.extend("refresh-period", value);
    }

    public String getSecure() {
        return this.parameters.get("secure");
    }

    public KnativeConfiguration withSecure(String value) {
        return this.extend("secure", value);
    }
}

