package io.smallrye.stork.servicediscovery.kubernetes;

import io.smallrye.stork.servicediscovery.kubernetes.KubernetesConfiguration;
import io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ServiceDiscoveryConfig;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.StorkInfrastructure;

/**
 * ServiceDiscoveryLoader for {@link io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider}
 */
 public class KubernetesServiceDiscoveryProviderLoader implements io.smallrye.stork.spi.internal.ServiceDiscoveryLoader {
   private final io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider provider = new io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider();
   @Override
   public ServiceDiscovery createServiceDiscovery(ServiceDiscoveryConfig config, String serviceName,
              ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
      io.smallrye.stork.servicediscovery.kubernetes.KubernetesConfiguration typedConfig = new io.smallrye.stork.servicediscovery.kubernetes.KubernetesConfiguration(config.parameters());
      return provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "kubernetes";
   }
}
