/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.kubernetes;

import io.smallrye.stork.api.config.ServiceDiscoveryConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KubernetesConfiguration
implements ServiceDiscoveryConfig {
    private final Map<String, String> parameters;

    public KubernetesConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public KubernetesConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "kubernetes";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private KubernetesConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new KubernetesConfiguration(copy);
    }

    public String getK8sHost() {
        return this.parameters.get("k8s-host");
    }

    public KubernetesConfiguration withK8sHost(String value) {
        return this.extend("k8s-host", value);
    }

    public String getK8sNamespace() {
        return this.parameters.get("k8s-namespace");
    }

    public KubernetesConfiguration withK8sNamespace(String value) {
        return this.extend("k8s-namespace", value);
    }

    public String getApplication() {
        return this.parameters.get("application");
    }

    public KubernetesConfiguration withApplication(String value) {
        return this.extend("application", value);
    }

    public String getRefreshPeriod() {
        String result = this.parameters.get("refresh-period");
        return result == null ? "5M" : result;
    }

    public KubernetesConfiguration withRefreshPeriod(String value) {
        return this.extend("refresh-period", value);
    }

    public String getSecure() {
        return this.parameters.get("secure");
    }

    public KubernetesConfiguration withSecure(String value) {
        return this.extend("secure", value);
    }
}

