/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.kubernetes;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.Metadata;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.CachingServiceDiscovery;
import io.smallrye.stork.impl.DefaultServiceInstance;
import io.smallrye.stork.servicediscovery.kubernetes.KubernetesConfiguration;
import io.smallrye.stork.servicediscovery.kubernetes.KubernetesMetadataKey;
import io.smallrye.stork.utils.ServiceInstanceIds;
import io.smallrye.stork.utils.ServiceInstanceUtils;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServiceDiscovery
extends CachingServiceDiscovery {
    static final String METADATA_NAME = "metadata.name";
    private final KubernetesClient client;
    private final String application;
    private final boolean allNamespaces;
    private final String namespace;
    private final boolean secure;
    private final Vertx vertx;
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesServiceDiscovery.class);
    private AtomicBoolean invalidated = new AtomicBoolean();

    public KubernetesServiceDiscovery(String serviceName, KubernetesConfiguration config, Vertx vertx) {
        super(config.getRefreshPeriod());
        Config base = Config.autoConfigure(null);
        String masterUrl = config.getK8sHost() == null ? base.getMasterUrl() : config.getK8sHost();
        this.application = config.getApplication() == null ? serviceName : config.getApplication();
        this.namespace = config.getK8sNamespace() == null ? base.getNamespace() : config.getK8sNamespace();
        boolean bl = this.allNamespaces = this.namespace != null && this.namespace.equalsIgnoreCase("all");
        if (this.namespace == null) {
            throw new IllegalArgumentException("Namespace is not configured for service '" + serviceName + "'. Please provide a namespace. Use 'all' to discover services in all namespaces");
        }
        Config k8sConfig = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(masterUrl)).withNamespace(this.namespace)).build();
        this.client = new KubernetesClientBuilder().withConfig(k8sConfig).build();
        this.vertx = vertx;
        this.secure = KubernetesServiceDiscovery.isSecure(config);
        this.client.endpoints().inform((ResourceEventHandler)new ResourceEventHandler<Endpoints>(){

            public void onAdd(Endpoints obj) {
                LOGGER.info("Endpoint added: {}", (Object)obj.getMetadata().getName());
                KubernetesServiceDiscovery.this.invalidate();
            }

            public void onUpdate(Endpoints oldObj, Endpoints newObj) {
                LOGGER.info("Endpoint updated : {}", (Object)newObj.getMetadata().getName());
                KubernetesServiceDiscovery.this.invalidate();
            }

            public void onDelete(Endpoints obj, boolean deletedFinalStateUnknown) {
                LOGGER.info("Endpoint deleted: {}", (Object)obj.getMetadata().getName());
                KubernetesServiceDiscovery.this.invalidate();
            }
        });
    }

    public Uni<List<ServiceInstance>> cache(Uni<List<ServiceInstance>> uni) {
        return uni.memoize().until(() -> this.invalidated.get());
    }

    public void invalidate() {
        this.invalidated.set(true);
    }

    public Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> previousInstances) {
        Uni endpointsUni = Uni.createFrom().emitter(emitter -> this.vertx.executeBlocking(future -> {
            HashMap items = new HashMap();
            if (this.allNamespaces) {
                List endpointsList = ((EndpointsList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.client.endpoints().inAnyNamespace()).withField(METADATA_NAME, this.application)).list()).getItems();
                for (Endpoints endpoint : endpointsList) {
                    ArrayList backendPods = new ArrayList();
                    List<String> podNames = endpoint.getSubsets().stream().flatMap(endpointSubset -> endpointSubset.getAddresses().stream()).map(address -> address.getTargetRef().getName()).collect(Collectors.toList());
                    podNames.forEach(podName -> backendPods.addAll(((PodList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.client.pods().inAnyNamespace()).withField(METADATA_NAME, podName)).list()).getItems()));
                    items.put(endpoint, backendPods);
                }
            } else {
                List endpointsList = ((EndpointsList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.endpoints().inNamespace(this.namespace)).withField(METADATA_NAME, this.application)).list()).getItems();
                for (Endpoints endpoint : endpointsList) {
                    ArrayList backendPods = new ArrayList();
                    List podNames = endpoint.getSubsets().stream().flatMap(endpointSubset -> endpointSubset.getAddresses().stream()).map(address -> address.getTargetRef().getName()).collect(Collectors.toList());
                    backendPods.addAll(podNames.stream().map(name -> (PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(name)).map(podPodResource -> (Pod)podPodResource.get()).collect(Collectors.toList()));
                    items.put(endpoint, backendPods);
                }
            }
            future.complete(items);
        }, result -> {
            if (result.succeeded()) {
                Map endpoints = (Map)result.result();
                emitter.complete((Object)endpoints);
            } else {
                LOGGER.error("Unable to retrieve the endpoint from the {} service", (Object)this.application, (Object)result.cause());
                emitter.fail(result.cause());
            }
        }));
        return endpointsUni.onItem().transform(endpoints -> this.toStorkServiceInstances((Map<Endpoints, List<Pod>>)endpoints, previousInstances)).invoke(() -> this.invalidated.set(false));
    }

    private List<ServiceInstance> toStorkServiceInstances(Map<Endpoints, List<Pod>> backend, List<ServiceInstance> previousInstances) {
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        for (Map.Entry<Endpoints, List<Pod>> entry : backend.entrySet()) {
            Endpoints endPoints = entry.getKey();
            List<Pod> pods = entry.getValue();
            for (EndpointSubset subset : endPoints.getSubsets()) {
                for (EndpointAddress endpointAddress : subset.getAddresses()) {
                    ServiceInstance matching;
                    String podName = endpointAddress.getTargetRef().getName();
                    String hostname = endpointAddress.getIp();
                    if (hostname == null) {
                        hostname = endpointAddress.getHostname();
                    }
                    List endpointPorts = subset.getPorts();
                    Integer port = 0;
                    String protocol = "";
                    if (endpointPorts.size() == 1) {
                        port = ((EndpointPort)endpointPorts.get(0)).getPort();
                        protocol = ((EndpointPort)endpointPorts.get(0)).getProtocol();
                    }
                    if ((matching = ServiceInstanceUtils.findMatching(previousInstances, (String)hostname, (int)port)) != null) {
                        serviceInstances.add(matching);
                        continue;
                    }
                    HashMap<String, String> labels = new HashMap<String, String>(endPoints.getMetadata().getLabels() != null ? endPoints.getMetadata().getLabels() : Collections.emptyMap());
                    Optional<Pod> maybePod = pods.stream().filter(pod -> pod.getMetadata().getName().equals(podName)).findFirst();
                    String podNamespace = this.namespace;
                    if (maybePod.isPresent()) {
                        ObjectMeta metadata = maybePod.get().getMetadata();
                        podNamespace = metadata.getNamespace();
                        Map podLabels = metadata.getLabels();
                        for (Map.Entry label : podLabels.entrySet()) {
                            labels.putIfAbsent((String)label.getKey(), (String)label.getValue());
                        }
                    }
                    Metadata k8sMetadata = Metadata.of(KubernetesMetadataKey.class);
                    serviceInstances.add((ServiceInstance)new DefaultServiceInstance(ServiceInstanceIds.next().longValue(), hostname, port.intValue(), this.secure, labels, k8sMetadata.with((Enum)KubernetesMetadataKey.META_K8S_SERVICE_ID, (Object)hostname).with((Enum)KubernetesMetadataKey.META_K8S_NAMESPACE, (Object)podNamespace).with((Enum)KubernetesMetadataKey.META_K8S_PORT_PROTOCOL, (Object)protocol)));
                }
            }
        }
        return serviceInstances;
    }

    private static boolean isSecure(KubernetesConfiguration config) {
        return config.getSecure() != null && Boolean.parseBoolean(config.getSecure());
    }
}

