package io.smallrye.stork.servicediscovery.kubernetes;

import io.smallrye.stork.servicediscovery.kubernetes.KubernetesConfiguration;
import io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.StorkInfrastructure;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * ServiceDiscoveryLoader for {@link io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider}
 */
 @ApplicationScoped
 public class KubernetesServiceDiscoveryProviderLoader implements io.smallrye.stork.spi.internal.ServiceDiscoveryLoader {
   private final io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider provider;
   public KubernetesServiceDiscoveryProviderLoader() {
       io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.servicediscovery.kubernetes.KubernetesServiceDiscoveryProvider();
       } 
       this.provider = actual;
   }

   @Override
   public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName,
              ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
      io.smallrye.stork.servicediscovery.kubernetes.KubernetesConfiguration typedConfig = new io.smallrye.stork.servicediscovery.kubernetes.KubernetesConfiguration(config.parameters());
      return provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "kubernetes";
   }
}
