package io.smallrye.stork.serviceregistration.consul;

import io.smallrye.stork.serviceregistration.consul.ConsulRegistrarConfiguration;
import io.smallrye.stork.serviceregistration.consul.ConsulServiceRegistrarProvider;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.config.ServiceRegistrarConfig;
import io.smallrye.stork.spi.StorkInfrastructure;
import jakarta.enterprise.inject.spi.CDI;
import io.smallrye.stork.impl.ConsulMetadataKey;
import io.smallrye.stork.api.MetadataKey;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * ServiceRegistrarLoader for {@link io.smallrye.stork.serviceregistration.consul.ConsulServiceRegistrarProvider}
 */
 @ApplicationScoped
 public class ConsulServiceRegistrarProviderLoader implements io.smallrye.stork.spi.internal.ServiceRegistrarLoader<ConsulMetadataKey> {
   private final io.smallrye.stork.serviceregistration.consul.ConsulServiceRegistrarProvider provider;
   public ConsulServiceRegistrarProviderLoader() {
       io.smallrye.stork.serviceregistration.consul.ConsulServiceRegistrarProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.serviceregistration.consul.ConsulServiceRegistrarProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.serviceregistration.consul.ConsulServiceRegistrarProvider();
       } 
       this.provider = actual;
   }

   @Override
   public ServiceRegistrar<ConsulMetadataKey> createServiceRegistrar(ConfigWithType config, String serviceName, 
              StorkInfrastructure storkInfrastructure) {
      io.smallrye.stork.serviceregistration.consul.ConsulRegistrarConfiguration typedConfig = new io.smallrye.stork.serviceregistration.consul.ConsulRegistrarConfiguration(config.parameters());
      return provider.createServiceRegistrar(typedConfig, serviceName, storkInfrastructure);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "consul";
   }
}
