/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.springboot;

import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.config.ConfigProvider;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import io.smallrye.stork.springboot.SpringBootApplicationContextProvider;
import io.smallrye.stork.utils.StorkConfigUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class SpringBootConfigProvider
implements ConfigProvider {
    private final List<ServiceConfig> serviceConfigs = new ArrayList<ServiceConfig>();

    public SpringBootConfigProvider() {
        ApplicationContext context = SpringBootApplicationContextProvider.getApplicationContext();
        ConfigurableEnvironment environment = (ConfigurableEnvironment)context.getEnvironment();
        HashMap propertiesByServiceName = new HashMap();
        for (String string : this.getPropertyNames(environment)) {
            StorkConfigUtils.computeServiceProperty(propertiesByServiceName, (String)string, (String)environment.getProperty(string));
        }
        for (Map.Entry entry : propertiesByServiceName.entrySet()) {
            SimpleServiceConfig serviceConfig = StorkConfigUtils.buildServiceConfig((Map.Entry)entry);
            this.serviceConfigs.add((ServiceConfig)serviceConfig);
        }
    }

    private List<String> getPropertyNames(ConfigurableEnvironment environment) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (PropertySource propertySource : environment.getPropertySources()) {
            String[] names;
            if (!(propertySource instanceof EnumerablePropertySource) || (names = ((EnumerablePropertySource)propertySource).getPropertyNames()) == null) continue;
            for (String name : names) {
                propertyNames.add(name);
            }
        }
        return propertyNames;
    }

    public List<ServiceConfig> getConfigs() {
        return this.serviceConfigs;
    }

    public int priority() {
        return 100;
    }
}

