/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.test;

import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.config.ConfigProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TestConfigProvider
implements ConfigProvider {
    private static final List<ServiceConfig> configs = new ArrayList<ServiceConfig>();
    private static int priority = 0x7FFFFFFE;

    public static void setPriority(int priority) {
        TestConfigProvider.priority = priority;
    }

    public static int getPriority() {
        return priority;
    }

    @Deprecated
    public static void addServiceConfig(String name, String loadBalancer, String serviceDiscovery, String serviceRegistrar, Map<String, String> loadBalancerParams, Map<String, String> serviceDiscoveryParams, boolean secure) {
        if (secure) {
            serviceDiscoveryParams.put("secure", "true");
        }
        TestConfigProvider.addServiceConfig(name, loadBalancer, serviceDiscovery, null, loadBalancerParams, serviceDiscoveryParams, null);
    }

    public static void addServiceConfig(final String name, final String loadBalancer, final String serviceDiscovery, final String serviceRegistrar, final Map<String, String> loadBalancerParams, final Map<String, String> serviceDiscoveryParams, final Map<String, String> serviceRegistrarParams) {
        configs.add(new ServiceConfig(){

            public String serviceName() {
                return name;
            }

            public ConfigWithType loadBalancer() {
                return loadBalancer == null ? null : new ConfigWithType(){

                    public String type() {
                        return loadBalancer;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(loadBalancerParams, Collections.emptyMap());
                    }
                };
            }

            public ConfigWithType serviceDiscovery() {
                return serviceDiscovery == null ? null : new ConfigWithType(){

                    public String type() {
                        return serviceDiscovery;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(serviceDiscoveryParams, Collections.emptyMap());
                    }
                };
            }

            public ConfigWithType serviceRegistrar() {
                return serviceRegistrar == null ? null : new ConfigWithType(){

                    public String type() {
                        return serviceRegistrar;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(serviceRegistrarParams, Collections.emptyMap());
                    }
                };
            }
        });
    }

    public static void clear() {
        configs.clear();
    }

    public List<ServiceConfig> getConfigs() {
        return configs;
    }

    public int priority() {
        return priority;
    }
}

