/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.test;

import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.config.ConfigProvider;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApplicationScoped
public class TestConfigProviderBean
implements ConfigProvider {
    private final List<ServiceConfig> configs = new ArrayList<ServiceConfig>();
    private int priority = Integer.MAX_VALUE;

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void addServiceConfig(final String name, final String loadBalancer, final String serviceDiscovery, final Map<String, String> loadBalancerParams, final Map<String, String> serviceDiscoveryParams) {
        this.configs.add(new ServiceConfig(){

            public String serviceName() {
                return name;
            }

            public ConfigWithType loadBalancer() {
                return loadBalancer == null ? null : new ConfigWithType(){

                    public String type() {
                        return loadBalancer;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(loadBalancerParams, Collections.emptyMap());
                    }
                };
            }

            public ConfigWithType serviceDiscovery() {
                return serviceDiscovery == null ? null : new ConfigWithType(){

                    public String type() {
                        return serviceDiscovery;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(serviceDiscoveryParams, Collections.emptyMap());
                    }
                };
            }

            public ConfigWithType serviceRegistrar() {
                return null;
            }
        });
    }

    public void addServiceConfig(final String name, final String loadBalancer, final String serviceDiscovery, final String serviceRegistrar, final Map<String, String> loadBalancerParams, final Map<String, String> serviceDiscoveryParams, final Map<String, String> serviceRegistrarParams) {
        this.configs.add(new ServiceConfig(){

            public String serviceName() {
                return name;
            }

            public ConfigWithType loadBalancer() {
                return loadBalancer == null ? null : new ConfigWithType(){

                    public String type() {
                        return loadBalancer;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(loadBalancerParams, Collections.emptyMap());
                    }
                };
            }

            public ConfigWithType serviceDiscovery() {
                return serviceDiscovery == null ? null : new ConfigWithType(){

                    public String type() {
                        return serviceDiscovery;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(serviceDiscoveryParams, Collections.emptyMap());
                    }
                };
            }

            public ConfigWithType serviceRegistrar() {
                return serviceRegistrar == null ? null : new ConfigWithType(){

                    public String type() {
                        return serviceRegistrar;
                    }

                    public Map<String, String> parameters() {
                        return Objects.requireNonNullElse(serviceRegistrarParams, Collections.emptyMap());
                    }
                };
            }
        });
    }

    public void clear() {
        this.configs.clear();
    }

    public List<ServiceConfig> getConfigs() {
        return this.configs;
    }

    public int priority() {
        return this.priority;
    }
}

