/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.testing.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class InMemoryLogHandler
extends Handler {
    final List<LogRecord> records = new ArrayList<LogRecord>();

    public InMemoryLogHandler(Predicate<LogRecord> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Parameter 'predicate' may not be null");
        }
        this.setFilter(predicate::test);
        this.setLevel(Level.FINE);
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.records.add(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.records.clear();
    }
}

