/*
 * Decompiled with CFR 0.152.
 */
package io.smartcat.cassandra.diagnostics;

import io.smartcat.cassandra.diagnostics.utils.Option;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Measurement {
    private final String name;
    private final MeasurementType type;
    private final Option<Double> value;
    private final long time;
    private final TimeUnit timeUnit;
    private final Map<String, String> tags;
    private final Map<String, String> fields;

    public String name() {
        return this.name;
    }

    public MeasurementType type() {
        return this.type;
    }

    public boolean isSimple() {
        return this.type.equals((Object)MeasurementType.SIMPLE);
    }

    public boolean isComplex() {
        return this.type.equals((Object)MeasurementType.COMPLEX);
    }

    public double getValue() {
        if (this.isComplex()) {
            throw new IllegalStateException("Complex measurement does not have value.");
        }
        return this.value.getValue();
    }

    public double getOrDefault(Double defaultValue) {
        return this.value.getOrDefault(defaultValue);
    }

    public long time() {
        return this.time;
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Map<String, String> fields() {
        return this.fields;
    }

    private Measurement(String name, MeasurementType type, Double value, long time, TimeUnit timeUnit, Map<String, String> tags, Map<String, String> fields) {
        this.name = name;
        this.type = type;
        this.value = Option.ofNullable(value);
        this.time = time;
        this.timeUnit = timeUnit;
        this.tags = tags;
        this.fields = fields;
    }

    public static Measurement createSimple(String name, Double value, long time, TimeUnit timeUnit, Map<String, String> tags, Map<String, String> fields) {
        if (value == null) {
            throw new IllegalArgumentException("Simple measurement must have a value.");
        }
        return new Measurement(name, MeasurementType.SIMPLE, value, time, timeUnit, tags, fields);
    }

    public static Measurement createComplex(String name, long time, TimeUnit timeUnit, Map<String, String> tags, Map<String, String> fields) {
        return new Measurement(name, MeasurementType.COMPLEX, null, time, timeUnit, tags, fields);
    }

    public String toString() {
        return "Measurement [ name=" + this.name + ", type=" + (Object)((Object)this.type) + ", value=" + (this.value.hasValue() ? (Serializable)this.value.getValue() : "null") + ", time=" + this.time + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", tags: " + this.tags + ", fields: " + this.fields + " ]";
    }

    public String toJson() {
        return "{\"name\":\"" + this.name + "\",\"type\":\"" + (Object)((Object)this.type) + "\",\"value\":" + (this.value.hasValue() ? (Serializable)this.value.getValue() : "null") + ",\"time\":" + this.time + ",\"timeUnit\":\"" + (Object)((Object)this.timeUnit) + "\",\"tags\":" + this.appendMap(this.tags) + ",\"fields\":" + this.appendMap(this.fields) + "}";
    }

    private String appendMap(Map<String, String> map) {
        StringBuilder builder = new StringBuilder("{");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append("\"");
            builder.append(entry.getKey());
            builder.append("\":\"");
            builder.append(entry.getValue());
            builder.append("\",");
        }
        if (builder.length() > 1) {
            builder.replace(builder.length() - 1, builder.length(), "}");
        } else {
            builder.append("}");
        }
        return builder.toString();
    }

    public static enum MeasurementType {
        SIMPLE,
        COMPLEX;

    }
}

