/*
 * Decompiled with CFR 0.152.
 */
package io.smartcat.cassandra.diagnostics;

public class Query {
    private long startTimeInMilliseconds;
    private long executionTimeInMilliseconds;
    private String clientAddress;
    private StatementType statementType;
    private String keyspace;
    private String tableName;
    private String statement;
    private ConsistencyLevel consistencyLevel;

    public long startTimeInMilliseconds() {
        return this.startTimeInMilliseconds;
    }

    public long executionTimeInMilliseconds() {
        return this.executionTimeInMilliseconds;
    }

    public String clientAddress() {
        return this.clientAddress;
    }

    public StatementType statementType() {
        return this.statementType;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String tableName() {
        return this.tableName;
    }

    public String fullTableName() {
        return this.keyspace + "." + this.tableName;
    }

    public String statement() {
        return this.statement;
    }

    public ConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    private Query(long startTimeInMilliseconds, long executionTimeInMilliseconds, String clientAddress, StatementType statementType, String keyspace, String tableName, String statement, ConsistencyLevel consistencyLevel) {
        this.startTimeInMilliseconds = startTimeInMilliseconds;
        this.executionTimeInMilliseconds = executionTimeInMilliseconds;
        this.clientAddress = clientAddress;
        this.statementType = statementType;
        this.keyspace = keyspace;
        this.tableName = tableName;
        this.statement = statement;
        this.consistencyLevel = consistencyLevel;
    }

    public static Query create(long startTimeInMilliseconds, long executionTimeInMilliseconds, String clientAddress, StatementType statementType, String keyspace, String tableName, String statement, ConsistencyLevel consistencyLevel) {
        return new Query(startTimeInMilliseconds, executionTimeInMilliseconds, clientAddress, statementType, keyspace, tableName, statement, consistencyLevel);
    }

    public String toString() {
        return "Query [ startTimeInMilliseconds=" + this.startTimeInMilliseconds + ", executionTimeInMilliseconds=" + this.executionTimeInMilliseconds + ", clientAddress=" + this.clientAddress + ", statementType=" + this.statementType.name() + ", statement=" + this.statement + ", keyspace=" + this.keyspace + ", tableName=" + this.tableName + ", consistencyLevel=" + this.consistencyLevel.name() + " ]";
    }

    public static enum ConsistencyLevel {
        ANY,
        ONE,
        TWO,
        THREE,
        QUORUM,
        ALL,
        LOCAL_QUORUM,
        EACH_QUORUM,
        SERIAL,
        LOCAL_SERIAL,
        LOCAL_ONE,
        UNKNOWN;

    }

    public static enum StatementType {
        SELECT,
        UPDATE,
        UNKNOWN;

    }
}

