/*
 * Decompiled with CFR 0.152.
 */
package io.smartcat.cassandra.diagnostics.connector;

import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import io.smartcat.cassandra.diagnostics.GlobalConfiguration;
import io.smartcat.cassandra.diagnostics.connector.Connector;
import io.smartcat.cassandra.diagnostics.connector.ConnectorConfiguration;
import io.smartcat.cassandra.diagnostics.connector.ExecuteStatementWrapper;
import io.smartcat.cassandra.diagnostics.connector.QueryReporter;
import io.smartcat.cassandra.diagnostics.info.InfoProvider;
import java.lang.instrument.Instrumentation;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorImpl
implements Connector {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorImpl.class);
    private static ExecuteStatementWrapper executeStatementWrapper;

    public static ExecuteStatementWrapper executeStatementWrapper() {
        return executeStatementWrapper;
    }

    @Override
    public void init(Instrumentation inst, QueryReporter queryReporter, ConnectorConfiguration configuration, GlobalConfiguration globalConfiguration) {
        executeStatementWrapper = new ExecuteStatementWrapper(queryReporter, configuration, globalConfiguration);
        ConnectorImpl.setIntercepters(inst);
    }

    @Override
    public void waitForSetupCompleted() {
        logger.info("Waiting for the driver setup process to complete.");
        logger.info("The driver setup process completed.");
    }

    @Override
    public InfoProvider getInfoProvider() {
        return null;
    }

    private static void setIntercepters(Instrumentation inst) {
        logger.info("Cassandra Diagnostics Connector: injecting com.datastax.driver.core.SessionManager#executeAsync interceptor");
        ElementMatcher.Junction type = ElementMatchers.named("com.datastax.driver.core.SessionManager");
        ByteBuddy byteBuddy = new ByteBuddy().with(Implementation.Context.Disabled.Factory.INSTANCE);
        new AgentBuilder.Default().with(byteBuddy).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.TypeStrategy.Default.REDEFINE).type(type).transform(new AgentBuilder.Transformer(){

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader) {
                return builder.visit(Advice.to(ExecuteStatementAdvice.class).on(ElementMatchers.named("executeAsync").and(ElementMatchers.takesArguments(ConnectorImpl.statementDescription())).and(ElementMatchers.returns(ElementMatchers.named("com.datastax.driver.core.ResultSetFuture")))));
            }
        }).installOn(inst);
    }

    private static TypeDescription statementDescription() {
        return new TypeDescription.Latent("com.datastax.driver.core.Statement", 1024, null, null);
    }

    public static class ExecuteStatementAdvice {
        @Advice.OnMethodEnter
        public static long enter() {
            long startTime = System.currentTimeMillis();
            return startTime;
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.Enter long startTime, @Advice.Argument(value=0) Statement statement, @Advice.Return ResultSetFuture result) {
            ConnectorImpl.executeStatementWrapper().processStatement(statement, startTime, result);
        }
    }
}

